#!/bin/bash

# Check if dataset name was provided
if [ -z "$1" ]; then
    echo "Usage: $0 <dataset>"
    exit 1
fi

# Capture the dataset argument
DATASET=$1

# Construct filenames
CONFIG_FILE="config/${DATASET}.config"

# Check if config file exists
if [ ! -f "$CONFIG_FILE" ]; then
    echo "Error: Config file '$CONFIG_FILE' not found!"
    exit 1
fi

# Source the config file
echo "Sourcing configuration from $CONFIG_FILE..."
source "$CONFIG_FILE"

case "$DATASET" in
    "quora")
        echo "Running script for Quora dataset..."
        python process_quora.py --dataset=$DATASET --pre_train=$PRE_TRAIN --hidden=$HIDDEN --embed_size=$EMBED_SIZE --dropout=$DROPOUT --size=$SIZE --probwt=$PROBWT --regularwt=$REGULARWT --containwt=$CONTAINWT --thresh=$THRESH --expid=$EXPID --epochs=$EPOCHS --batch_size=$BATCH_SIZE --lr=$LR --lr_projection=$LR_PROJECTION --eps=$EPS --optim=$OPTIM --version=$VERSION --cuda=$CUDA --gpu_id=$GPU_ID --seed=$SEED

        ;;
    "movielens")
        echo "Running script for MovieLens dataset..."
        python process_ml_latest.py --dataset=$DATASET --pre_train=$PRE_TRAIN --hidden=$HIDDEN --embed_size=$EMBED_SIZE --dropout=$DROPOUT --size=$SIZE --probwt=$PROBWT --regularwt=$REGULARWT --expid=$EXPID --epochs=$EPOCHS --batch_size=$BATCH_SIZE --lr=$LR --lr_projection=$LR_PROJECTION --eps=$EPS --optim=$OPTIM --version=$VERSION --cuda=$CUDA --gpu_id=$GPU_ID --seed=$SEED --minratingnum=$MINRATINGNUM

        ;;
    "ucsd")
        echo "Running script for UCSD dataset..."
        python process_ucsd.py --dataset=$DATASET --pre_train=$PRE_TRAIN --hidden=$HIDDEN --embed_size=$EMBED_SIZE --size=$SIZE --probwt=$PROBWT --regularwt=$REGULARWT --containwt=$CONTAINWT --expid=$EXPID --epochs=$EPOCHS --batch_size=$BATCH_SIZE --lr=$LR --lr_projection=$LR_PROJECTION --eps=$EPS --optim=$OPTIM --version=$VERSION --cuda=$CUDA --gpu_id=$GPU_ID --seed=$SEED --mini=$MINI
        ;;
    "environment")
        echo "Running script for SemEval-Environment dataset..."
        python main.py --dataset=$DATASET --negsamples=$NEGSAMPLES --embed_size=$EMBED_SIZE --gpu_id=$GPU_ID
        ;;
    "science")
        echo "Running script for SemEval-Science dataset..."
        python main.py --dataset=$DATASET --negsamples=$NEGSAMPLES --embed_size=$EMBED_SIZE --gpu_id=$GPU_ID
        ;;
    "food")
        echo "Running script for SemEval-Food dataset..."
        python main.py --dataset=$DATASET --negsamples=$NEGSAMPLES --embed_size=$EMBED_SIZE --gpu_id=$GPU_ID
        ;;
    *)
        echo "Unknown dataset: $DATASET"
        exit 1
        ;;
esac